<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:variable name="exportType">HTML</xsl:variable>
  <xsl:key name="product" match="/items/item/products/product/text()" use="." />
  
  <xsl:template match="report">
    	<html><head><style>
		body{font-family: "Segoe UI", "Arial",sans-serif;}
		body {padding:15px;}
		body, table, td, th{font-size:9pt; color:#555555}
		tr.header th{color:#ffffff; background-color:#555555}
		tr.header th.projectName{background-color:#cb5252}
		table{border-right:1px solid #cccccc;}
		th {padding:5px}
		th.subheader{border-top:2px solid #555555; border-bottom:1px solid #cccccc; background-color:#f2f8fd}
		td {border-bottom:1px solid #cccccc; border-left:1px solid #cccccc; padding:5px}
		td.total, th.total{background-color:#bdf4bb}
		ul {
			list-style-type:none;	
		}
		
		ul#projects li h2 {
			margin:0px;
			font-size:150%;
			height:45px;
			overflow:clip;
		}
		
		ul#projects li h2.small {
			font-size:120%;
			
		}
		
		ul#projects li h3 {
			margin:0 0 5px 0;
			font-size:170%;
			font-weight:normal;
		}
		
		ul#projects li{
			width:150px;
			height:275px;
			border:1px solid #cccccc;
			float:left;
			margin-right:10px;
			margin-top:10px;
			border-top-width:5px;
			padding: 0 10px 10px 10px;
			
		}
		ul#projects li ul li{
			width:auto;
			height:auto;
			min-height:0;
			float:none;
			margin-right:0px;
			margin-top:0px;
			padding: 0;
			border-width:0px;
		}
		
		h1 {
			clear:left;
		}
		
		ul#header {
			clear:both;
		}
		
		ul#header li {
			width:25%;
			margin-right:3%;
			float:left;
			border: 1px solid #dddddd;
			padding:5px;
		}
		ul#header li h2 {
			margin: 0 0 2px 0;
		}
		
		p.total {
			margin-top:0;
			padding-top:0;
			font-size:150%
		}
		</style>
		</head>
		<script>
		<![CDATA[
		  window.onload = function() {
			var canvases = document.getElementsByTagName("canvas");
			for (var i =0; i < canvases.length; i++) {
				var canvas = canvases[i];
				var percentage = -canvas.getAttribute("data-billable");
				var context = canvas.getContext("2d");
				var x = canvas.width / 2;
				var y = canvas.height / 2;
				var radius = 55;
				var counterClockwise = true;
				
				//first draw a complete ring
				context.beginPath();
				context.arc(x, y, radius, 0, 2 * Math.PI, counterClockwise);
				context.lineWidth = 15;
				// line color
				context.strokeStyle = "#bdccd4";
				context.stroke();
				
				var startAngle = 0 - .5 * Math.PI;
				var endAngle = 2 * Math.PI * percentage  - .5 * Math.PI;
				

				context.beginPath();
				context.arc(x, y, radius, startAngle, endAngle, counterClockwise);
				context.lineWidth = 15;
				// line color
				context.strokeStyle = "#7ac943";
				context.stroke();
				
				//add the text
				context.textBaseline = 'middle';
				context.textAlign = "center";
				
				
				var asPercent = Math.round(-percentage * 100);
				if (isNaN(asPercent)) {
					asPercent = "NA";
				} else {
					asPercent += "%";
					context.font = '14px sans-serif';
					context.fillText('Billable', x, y + 20);
				}
				context.font = '30px sans-serif';
				context.fillText(asPercent, x, y-5);
				
				
			}
		  };
		]]>
		</script>
		<body>
		<h1>Totals</h1>	
			<ul id="header">
				
				<li style="background-color:#7ac943; color:white;">
					<h2>Total Billable Duration</h2>
					<p class="total">
						<xsl:variable name="totalBillableDuration" select="sum(entries/entry[billable ='true']/duration)"/>
						
						<xsl:call-template name="minutesToHours">
							<xsl:with-param name="minutes" select="$totalBillableDuration div 60000"/> 
						</xsl:call-template>
					</p>
				</li>
				<li style="background-color:#bdccd4; color:white;">
					<h2>Total Non-Billable Duration</h2>
					<p class="total">
						<xsl:variable name="totalNonBillableDuration" select="sum(entries/entry[billable!='true']/duration)"/>
						
						<xsl:call-template name="minutesToHours">
							<xsl:with-param name="minutes" select="$totalNonBillableDuration div 60000"/> 
						</xsl:call-template>
					</p>
				</li>
				<li style="background-color:#555555; color:white;">
					<h2>Total Duration</h2>
					<p class="total">
						<xsl:variable name="totalDuration" select="sum(entries/entry/duration)"/>
						
						<xsl:call-template name="minutesToHours">
							<xsl:with-param name="minutes" select="$totalDuration div 60000"/> 
						</xsl:call-template>
					</p>
				</li>
			</ul>
			<xsl:apply-templates select="projects"/>
			<xsl:apply-templates select="people"/>
		</body>
		</html>
		
  </xsl:template>
  
  <xsl:template match="projects">
  <h1>Project Summary</h1>
	<ul id="projects">
		<xsl:apply-templates select="project[rollup_children='true']"/>
	</ul>
  </xsl:template>
  
  <xsl:template match="project">
	<xsl:variable name="rollupTo" select="rollup_to"/>
	<xsl:if test="sum(//entries/entry[rollup_to = $rollupTo]/duration) &gt; 0">
	
	<li>
		<xsl:attribute name="style">border-top-color:<xsl:call-template name="toHexColor">
				<xsl:with-param name="decimalNumber" select="color"/> 
		</xsl:call-template>; </xsl:attribute>
		<!--background-color:<xsl:call-template name="toRGBAColor">
					<xsl:with-param name="decimalNumber" select="color"/> 
					<xsl:with-param name="opacity" select="'.1'"/>
			</xsl:call-template>;-->
			<h2>
			<xsl:if test="string-length(name) &gt; 25">
					<xsl:attribute name="class">small</xsl:attribute>
				</xsl:if>
			<xsl:value-of select="name"/></h2>
			
			<h3>
			<xsl:call-template name="minutesToHours">
				<xsl:with-param name="minutes" select="sum(//entries/entry[rollup_to = $rollupTo]/duration) div 60000"/> 
			</xsl:call-template>
			</h3>
			<ul>
			<li>
				<xsl:value-of select="count(//entries/entry[rollup_to = $rollupTo])"/> 
				Entries
			</li>
			<li>
				<xsl:value-of select="count(//entries/entry[rollup_to = $rollupTo and not(following::entry[rollup_to = $rollupTo]/resource_id/text() = resource_id/text())])"/>
				User(s)
			</li>
			<li>
				<xsl:value-of select="count(//entries/entry[rollup_to = $rollupTo and not(following::entry[rollup_to = $rollupTo]/project_id/text() = project_id/text())])"/>
				Sub Project(s)
			</li>
			</ul>
			<canvas width="150" height="150">
				<xsl:attribute name="data-billable">
					<xsl:value-of select="sum(//entries/entry[rollup_to = $rollupTo and billable='true']/duration) div sum(//entries/entry[rollup_to = $rollupTo]/duration)"/>
				</xsl:attribute>
			</canvas>
			
			
		
	</li>
	</xsl:if>
	
  </xsl:template>
  
  <xsl:template match="people">
  <h1>User Summary</h1>
	<ul id="projects">
		<xsl:apply-templates select="person"/>
	</ul>
  </xsl:template>
  <xsl:template match="person">
	<xsl:variable name="resourceId" select="resource_id"/>
	
	<xsl:variable name="totalDuration" select="sum(//entries/entry[resource_id = $resourceId]/duration)"/>
	<xsl:if test="$totalDuration &gt; 0">
	
	<li>
	
	<xsl:attribute name="style">border-top-color:<xsl:call-template name="toHexColor">
				<xsl:with-param name="decimalNumber" select="color"/> 
		</xsl:call-template>; </xsl:attribute>
			
			<h2>
				<xsl:if test="string-length(name) &gt; 25">
					<xsl:attribute name="class">small</xsl:attribute>
				</xsl:if>
			<xsl:value-of select="name"/></h2>
			
			<h3>
			
			<xsl:call-template name="minutesToHours">
				<xsl:with-param name="minutes" select="$totalDuration div 60000"/> 
			</xsl:call-template>
			</h3>
			<ul>
			<li>
				<xsl:value-of select="count(//entries/entry[resource_id = $resourceId])"/> 
				Entries
			</li>
			
			<li>
				<xsl:value-of select="count(//entries/entry[resource_id = $resourceId and not(following::entry[resource_id = $resourceId]/project_id/text() = project_id/text())])"/>
				Project(s)
			</li>
			</ul>
			<canvas width="150" height="150">
				<xsl:attribute name="data-billable">
					<xsl:value-of select="sum(//entries/entry[resource_id = $resourceId and billable='true']/duration) div sum(//entries/entry[resource_id = $resourceId]/duration)"/>
				</xsl:attribute>
			</canvas>
			
			
		
	</li>
	</xsl:if>
	
  </xsl:template>
  <xsl:template name="minutesToHours">
	<xsl:param name="minutes"/>
	<xsl:value-of select="floor($minutes div 60)"/>:<xsl:if test="$minutes mod 60 &lt; 10">0</xsl:if><xsl:value-of select="$minutes mod 60"/>
	
  </xsl:template>
  
  
  <xsl:template name="toHex">
     <xsl:param name="decimalNumber" />
	 
     <xsl:if test="$decimalNumber >= 16">
      <xsl:call-template name="toHex">
         <xsl:with-param name="decimalNumber"  select="floor($decimalNumber div 16)" />
       </xsl:call-template>
     </xsl:if>
	 
     <xsl:value-of select="substring('0123456789ABCDEF', ($decimalNumber mod 16) + 1, 1)" />
 </xsl:template>
 <xsl:template name="to-rgb">
        <xsl:param name="val"/>
        <xsl:param name="hex-key" select="'0123456789ABCDEF'"/>
       
        <xsl:value-of select="string-length(substring-before($hex-key,substring($val,1,1)))*16 + string-length(substring-before($hex-key,substring($val,2,1)))" />
       
    </xsl:template>
	
 <xsl:template name="hex-to-rgb">
	<xsl:param name="asHex"/>
	<xsl:param name="count" select="1"/>
	
	<xsl:variable name="hex-val" select="translate($asHex,'abcdef#','ABCDEF')"/>
	<xsl:variable name="val" select="substring($hex-val,1,2)"/>
	<xsl:variable name="tail" select="substring-after($hex-val,$val)"/>
   
		<xsl:choose>
		<xsl:when test="$count &lt; 3">
		
			<xsl:call-template name="to-rgb">
				<xsl:with-param name="val" select="$val"/>
			</xsl:call-template><xsl:text>, </xsl:text>
			<xsl:call-template name="hex-to-rgb">
				<xsl:with-param name="count" select="$count + 1"/>
				<xsl:with-param name="asHex" select="$tail"/>
			</xsl:call-template>
			
		</xsl:when>
		<xsl:otherwise>
			
			<xsl:call-template name="to-rgb">
				<xsl:with-param name="val" select="$val"/>
			</xsl:call-template>            
		</xsl:otherwise>
		
	</xsl:choose>
 </xsl:template>	
<xsl:template name="toRGBAColor">
	<xsl:param name="decimalNumber"/>
	<xsl:param name="opacity"/>
	<xsl:variable name="asHex">
		<xsl:call-template name="toHexColor">
			<xsl:with-param name="decimalNumber" select="$decimalNumber"/>
		</xsl:call-template>	
	</xsl:variable>
	<xsl:variable name="asRGB">
	<xsl:call-template name="hex-to-rgb">
		<xsl:with-param name="asHex" select="$asHex"/>
	</xsl:call-template>
	</xsl:variable>
	<xsl:text>rgba(</xsl:text><xsl:value-of select="$asRGB"/><xsl:text>, </xsl:text><xsl:value-of select="$opacity"/><xsl:text>)</xsl:text>
 </xsl:template>
 
 <xsl:template name="toHexColor">
	<xsl:param name="decimalNumber"/>
	<xsl:variable name="asHex">
		<xsl:call-template name="toHex">
			<xsl:with-param name="decimalNumber" select="$decimalNumber"/>
		</xsl:call-template>	
	</xsl:variable>
	
	<xsl:choose>
		<xsl:when test="string-length($asHex) = 1">#00000<xsl:value-of select="$asHex"/></xsl:when>
		<xsl:when test="string-length($asHex) = 2">#0000<xsl:value-of select="$asHex"/></xsl:when>
		<xsl:when test="string-length($asHex) = 3">#000<xsl:value-of select="$asHex"/></xsl:when>
		<xsl:when test="string-length($asHex) = 4">#00<xsl:value-of select="$asHex"/></xsl:when>
		<xsl:when test="string-length($asHex) = 5">#0<xsl:value-of select="$asHex"/></xsl:when>
		<xsl:when test="string-length($asHex) = 6">#<xsl:value-of select="$asHex"/></xsl:when>
		<xsl:otherwise>#cccccc</xsl:otherwise>
	</xsl:choose>
 </xsl:template>
	
</xsl:stylesheet>